package aln.SpawnCommands;

import java.util.Arrays;
import java.util.List;

import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;

public class CommandSpawnPlus implements ICommand {

  @Override
  public int compareTo(Object arg0) {
    return 0;
  }

  @Override
  public String getCommandName() {
    //return "spawn+";
	return Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn+");
  }

  @Override
  public String getCommandUsage(ICommandSender icommandsender) {
    return "/"+Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn+")+" nametoadd or op only /spawn+ enable or /spawn+ disable";
  }

  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }

  @Override
  public void processCommand(ICommandSender icommandsender, String[] params) {
    if(icommandsender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) icommandsender;
      if ( player.worldObj.isRemote ) { return; }

      SpawnCommands.loadCommandPermissionsConfig();
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn+").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) {
        Do.Say(player,"Advanced commands are not enabled for SpawnCommands.");
      	if ( (params.length == 1) && (( params[0].equalsIgnoreCase("enable") || params[0].equalsIgnoreCase("enabled")) ) ) { 
      	  Do.Say(player,"  Yes this is the enable command. See config files.");
      	}
      	return;
      }
      
      SpawnCommands.commandSpawnPlus(player, params);
      
    }
  }
  
  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }

  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }

  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }

}
